Attribute VB_Name = "modGeneral"
Option Explicit
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
' http://www.TheScarms.com/AppSentinel
'         TheScarms (TM)
'
' This source code may not be redistributed. Redistributing
' this source code is a violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinel DLLs.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.

'
' Return values from the fRegister routine.
'
Private Const cregRegistered = 0
Private Const cregEvaluating = 1
Private Const cregExpired = 2
Private Const cregError = -99

' Create a variable to reference the AppSentinel object.
'
' IMPORTANT:
' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
'
'Public gobjAppSentinel As New SEN10L.Registration  'Release version
'Public gobjAppSentinel As New SEN10LT.Registration 'Trial version
Public gobjAppSentinel As Object

' Your app's name and your company's name.
' No spaces or strange characters allowed.
Public Const cYourAppName = "YourAppName1"
Public Const cYourCompanyName = "YourCompanyName"

' Registry key in which to store data.
Public Const cSubKey = cYourCompanyName & "\" & cYourAppName
Public Sub Main()
Dim lngResult   As Long
Dim strTemp     As String
Dim strError    As String
Dim strPassword As String

    ' Only allow one instance of your app.
    If App.PrevInstance Then End
    
    ' IMPORTANT:
    ' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
    
    'Set gobjAppSentinel = CreateObject("SEN10L.Registration")
    Set gobjAppSentinel = CreateObject("SEN10LT.Registration")
    '
    ' Set your evaluation period and required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays       The number of days to allow in your trial period.
    '
    gobjAppSentinel.TrialDays = 3
    gobjAppSentinel.FileMask = "YourMask1"
    gobjAppSentinel.RegistrySubkey = cSubKey
    
    ' Check the registration information.
    lngResult = fRegister(strError)
    
    Select Case lngResult
        Case cregRegistered
            ' Your application is properly registered.
            ' Check if the 90 day Rental period has expired.
            If gobjAppSentinel.TotalDays > 90 Then
                ' It has expired. Remove all registration information.
                ' ALL APPSENTINEL PROPERTIES ARE CLEARED BY THIS METHOD.
                
                ' The release version requires a valid password.
                'strPassword = 'Calculate password.
                Call gobjAppSentinel.DeleteRegistration(strPassword, strError)
                
                ' You MUST do this. Otherwise, partial registration
                ' information may be recreated.
                Set gobjAppSentinel = Nothing
                
                ' Inform the user and get out.
                Call MsgBox("Your rental period has expired." & vbCrLf & _
                            "This application will terminate.", vbCritical, "Rental Period Expired")
                
                ' At this point your application will be unregistered. Next time the
                ' user runs it they will have a new evaluation period (3 days in this
                ' example).
                
                ' Terminate your application.
                GoTo NormalExit
                
            ElseIf gobjAppSentinel.TotalDays >= 85 Then
                ' There are a few days left in the rental period. You may want
                ' to display this information and instruct the user how to renew.
                
                strTemp = "You have " & CStr(90 - gobjAppSentinel.TotalDays) & " day(s) remaining in your rental period."
                Call MsgBox(strTemp, vbExclamation, "Time to Renew")
            End If
            ' You may want to enable certain features,
            ' hide your registration screen,....
            'Call pDoRegistrationStuff()
            
            ' Show your first form.
            frmMain.Show vbModal
        Case cregEvaluating
            ' The user still has time and/or runs left in the evaluation period.
            ' You may want to display this infor and tell them how to register.
            If Val(gobjAppSentinel.DaysLeft) <= 5 Then
                strTemp = "You have " & gobjAppSentinel.DaysLeft & " day(s) remaining in your evaluation period."
                Call MsgBox(strTemp, vbExclamation, "Evaluation Period")
            End If
            
            ' You may want to show your splash screen, disable features,....
            'Call pDoEvaluationStuff()
            
            ' Show your first form.
            frmMain.Show vbModal
        Case cregExpired
            ' The evaluation period has expired.
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            
            ' This sample has logic in fRegister to redisplay the
            ' registration form giving the user a chance to register.
            '
            ' NOTE:
            ' If you terminate your app using the END statement, you MUST
            ' Set gobjAppSentinel = Nothing first. See ObjectBinding.htm.
            Call MsgBox("This application will shut down.", vbCritical, "Evaluation Period Expired")
            Set gobjAppSentinel = Nothing
            GoTo NormalExit
        Case cregError
            ' Something went wrong. Tell the user.
            Call MsgBox(strError, vbCritical, "Error Verifying Registration")
            ' Assume the app is not registered and end your program.
            GoTo NormalExit
            ' If strError is an 'Internal Error', report the problem to
            ' Sales@TheScarms.com providing as much detail as possible.
    End Select

NormalExit:
    On Error Resume Next
    ' You MUST ALWAYS do this before ending your program.
    Set gobjAppSentinel = Nothing
    End
End Sub
Private Function fRegister(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    fRegister = cregExpired
    On Error GoTo ErrorHandler

    ' Read/check registration information.
    If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
    If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
    
    ' See if application is registered.
    If gobjAppSentinel.Registered Then
        fRegister = cregRegistered
        Exit Function
    End If
    
    If gobjAppSentinel.Expired Then
        ' Trial period has expired.
        fRegister = cregExpired
        
        ' Show registration form and recheck
        ' registration in case user just registered.
        frmRegister.Show vbModal
        If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
        If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
        If gobjAppSentinel.Registered Then fRegister = cregRegistered
    Else
        'Still within trial period.
        fRegister = cregEvaluating
    End If
    Exit Function
    
ErrorHandler:
    ' A method of AppSentinel returned false. Assume
    ' your application is not registered or expired.
    fRegister = cregError
    If strError = "" Then strError = Err.Description
End Function


